//
//  BPAdminDefines.h
//  BPAdmin
//
//  Created by Michael Clark on 13/06/09.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

// Auto-generated file which contains shared, network-related constants and enum types
#import <BPAdmin/BPAdminSharedConstants.h>



extern NSString*   kBPAdminUsername;

// PG Version we are currently including - used for path construction and also for various tests
extern NSString*   kBPAdminPGVersion;


enum {

	kBPAdminBI3RestoreErrorUndefined = 0,
	kBPAdminBI3RestoreErrorExtraction,
	kBPAdminBI3RestoreErrorBusy,
	kBPAdminBI3RestoreErrorMigration,
    kBPAdminBI3RestoreErrorInvalidBI3Backup
};


// Error domain
extern NSString *kBPAdminDomain;

// File and Folder constants
extern NSString*   kBPPGServerSupportFolderName;
extern NSString*   kBPAdminTempPasswordFilePath;

extern NSString*   kBPAdminPublicPasswordFilename;

extern NSString*   kBPAdminDatabaseName;
extern NSString*   kBPAdminDBSuperuserUsername;
extern NSString*   kBPAdminDBBasicUsername;

extern NSString*   kBPDatabaseName;
extern NSString*   kBPDatabaseOfflineName;

extern NSString*   kBPAdminBackupExtension;

extern NSString*   kBPEventTrackerDatabaseFileName;

extern NSString*   kBPAdminKeychainFilename;

extern NSString*   kBPPreprocessingScriptName;

extern NSString*   kBPAdminHostedStageRootPath;


#pragma mark -
#pragma mark Database Record Keys
extern NSString* kBPPGServerIsValidFlagKey;
extern NSString* kBPPGServerUUIDKey;
extern NSString* kBPPGServerPublicAddressKey;
extern NSString* kBPPGServerPrivateAddressKey;
extern NSString* kBPPGServerDatabaseUUIDKey;
extern NSString* kBPPGServerDatabaseNumUsersKey;
extern NSString* kBPPGServerDatabaseActiveUsersKey;
extern NSString* kBPPGServerDatabaseUsersStringKey;
extern NSString* kBPPGServerDatabaseOfflinesArrayKey;
extern NSString* kBPPGServerDatabaseTypeKey;
extern NSString* kBPPGServerDatabaseActiveFlagKey;


#pragma mark -
#pragma mark License Record Keys
extern NSString* kBPPGServerLicenseIDKey;
extern NSString* kBPPGServerLicenseLicenseCodeKey;
extern NSString* kBPPGServerLicenseSerialCodeKey;
extern NSString* kBPPGServerLicenseProductNameKey;
extern NSString* kBPPGServerLicenseSeatsKey;
extern NSString* kBPPGServerLicenseExpiryDateKey;


extern NSDictionary* kBPPGServerProductCodeMapping;
extern NSDictionary* kBPPGServerVersionMapping; // Maps product code to version string
extern NSDictionary* kBPPGServerLicenseBundleMapping; // Maps product code to real product codes - for bundles like DP = DL and DM
extern NSDate* kBPPGServerLicenseNoEndDateDate;  // Used to flag what should be interpreted as the product never expiring


#pragma mark -
#pragma mark Overide Key for Launchd
/*!

 Launch Accessd or TouchD with this argument and both will look for that file (plist) and use the debug or service down keys and info to return the client app.
 
 Note: return codes are different for the desktop vs touch. Be careful not to mix those up.
 
 <key>ProgramArguments</key>
 <array>
 <string>/Users/Shared/aj/Developer/SharedBillingsProBuild/Products/Debug/Billings Pro Server.bundle/Contents/Resources/BPTouchd</string>
 <string>-Hosted</string>
 <string>YES</string>
 <string>-OverideSettingsPath</string>
 <string>/Users/aj/Developer/BPSAccessdOverride.plist</string>
 </array>
 
 
 Example override plist:
 {
    ServiceDown = NO;
    ServiceDownInfoURL = "http://www.marketcircle.com/status/";
    Debug = YES;
    DebugAuthReturnCode = 5;
 }


 */
extern NSString *kBPSOverideResponsePathKey;

extern NSString* kBPSServiceDownKey; // ServiceDown (YES or NO)
extern NSString* kBPSMoreInfoURLKey; // MoreInfoURL

extern NSString* kBPSDebugMode; // Debug (YES or NO)
extern NSString* kBPSDebugAuthReturnCode; // DebugAuthReturnCode
extern NSString* kBPSDebugAdditionalReturnArgs; // DebugAdditionalReturnArgs -- a dictionary of whatever return args. gets added to the response dictionary


#define kBPPGServerTrialDays 30


#define     kBPAdminDBSuperuserPasswordPrivateKey @"MKEITRUTJDK"
#define     kBPAdminDBBasicPasswordPrivateKey     @"OPJFIRKTEIM"


#pragma mark -
#pragma mark Port Numbers
#define kBPPGServerAuthorizationPort     7113
#define kBPPGServerConfigKickPort        7114
#define kBPPGServerConfigDOPort          7115
#define kBPPGServerPostgresPort          7116
#define kBPPGServerTouchPort             7117
#define kBPPGServerHTTPPort              7118

#define BPADMIN_USE_SSL 1


#pragma mark Discovery Service Identifiers
extern NSString *kBPAAccessdServiceIdentifier;
extern NSString *kBPATouchdServiceIdentifier;


#pragma mark BPSA - portsd distributed notfis

// BPPortsd has new values
extern NSString * kBPPortsdStatusChangedNotification;

// BPSA changed settings of portsd
extern NSString * kBPSAPortsdUpdateNotif;
extern NSString * kBPSADisabledUpnp;
extern NSString * kBPSAEnabledUpnp;
extern NSString * kBPSAStartedTouchServerNotification;
extern NSString * kBPSAStoppedTouchServerNotification;
// User wants to update the ip manually

extern NSString * kBPSAPortsdUpdateIPRequestNotification;

// Portsd did start updating the IPAddress

extern NSString * kBPPortsdDidStartUpdatingIPAddressNotification;

// Portsd updated (or failed) the IP

extern NSString *kBPPortsdDidUpdateIPAddressNotification;
extern NSString *kBPPortsdFailedToUpdateIPAddressNotification;

extern NSString *kBPSACheckConnectivityRequestNotification;

extern NSString *kBPPortsdNotifObject;

@interface BPAdminDefines : NSObject {}

+ (NSString *)syncHelperServerName;

@end

